;;;--------------------------------------------------------------------------;
;;; Exporta vertices de MULTIPLAS 3DPolylines para TXT tabulado
;;; Colunas: PolyID    VertexID    X    Y    Z
;;;	Ad33 Geo - 2026
;;; Gerado por IA - verifique se o arquivo atende à sua necessidade antes de usar.
;;; ChatGPT 5.2 Thinking Standard
(defun c:3txt (/ ss fVar fOut i ent obj pts pidx vid tab fmt *error*)
(vl-load-com)
(setq tab (chr 9))
(defun *error* (msg)(if fVar (close fVar))(princ))
(defun fmt (v)(vl-string-translate "," "." (rtos v 2 6)))
(defun Extract_3DPoly_Vertexes (Ent / cLst oLst)
(if (= 'ENAME (type Ent))(setq Ent (vlax-ename->vla-object Ent)))
(if (= "AcDb3dPolyline" (vla-get-ObjectName Ent))
(progn
(setq cLst (vlax-safearray->list (vlax-variant-value (vla-get-Coordinates Ent))))
(while cLst
(setq oLst (cons (list (car cLst) (cadr cLst) (nth 2 cLst)) oLst))
(repeat 3 (setq cLst (cdr cLst))))
(reverse oLst))))
(prompt "\nSelecione as 3DPolylines (pode selecionar varias) > ")
(setq ss (ssget '((0 . "POLYLINE"))))
(if ss
(progn
(setq fOut (strcase (strcat (getvar "DWGPREFIX") (vl-filename-base (getvar "DWGNAME")) "_3dplines.txt")))
(setq fVar (open fOut "w"))
(write-line (strcat "PolyID" tab "VertexID" tab "X" tab "Y" tab "Z") fVar)
(setq pidx 0)
(setq i 0)
(while (< i (sslength ss))
(setq ent (ssname ss i))
(setq obj (vlax-ename->vla-object ent))
(if (= "AcDb3dPolyline" (vla-get-ObjectName obj))
(progn
(setq pidx (+ pidx 1))
(setq pts (Extract_3DPoly_Vertexes ent))
(setq vid 0)
(foreach pt pts
(setq vid (+ vid 1))
(write-line
(strcat (itoa pidx) tab (itoa vid) tab (fmt (car pt)) tab (fmt (cadr pt)) tab (fmt (last pt)))
fVar))))
(setq i (+ i 1)))
(close fVar)
(alert (strcat "TXT gerado em:" "\n" fOut)))
(princ "<!> Nenhuma 3DPolyline selecionada <!> "))
(princ))
(princ "\nType 3txt to run")
